<?php
defined('BASEPATH') or exit('No direct script access allowed');

class IndexControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->model("IndexModel");
        $this->load->model("SliderModel");
        $this->load->model("VideoModel");
        $this->load->model("AdvertisementModel");
        $this->load->model("StudentFeedbackModel");
        $this->load->model("ClientModel");
        $this->load->model("PlacedStudentModel");
        $this->load->model("CategoryModel");
        $this->load->model("GalleryModel");
        $this->load->model("PaperCuttingModel");      
        $this->load->model("QuestionAnswerModel");
        $this->load->model("EventModel");        
        $this->load->model("CourseModel");
        $this->load->model("RegistrationModel");
        
        
        $this->load->model("NewsModel");
        
        

        $this->load->library("form_validation");
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $result['all_front_slider'] = $this->SliderModel->manageActiveInfo();
        $result['all_placed_student'] = $this->PlacedStudentModel->selectInfoFront();
        $result['all_student_feedback'] = $this->StudentFeedbackModel->selectActiveInfo();
        $result['all_clint_info'] = $this->ClientModel->selectInfoFront();
        $result['all_course_info'] = $this->CourseModel->selectInfoFront();
        
        $result['all_info_cat'] = $this->CategoryModel->selectLatestFrontInfoLimit();

        $result['all_gallery_info'] = $this->GalleryModel->selectActiveInfo();

        $result['all_event_info'] = $this->EventModel->selectEventInfoActive();
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        
        
        $result['all_registration_info'] = $this->RegistrationModel->getAllInfoLatest();
        
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        
        $result['all_add_info_left'] = $this->AdvertisementModel->manageFrontInfo(2);
        $result['all_add_info_right'] = $this->AdvertisementModel->manageFrontInfo(3);
        
        
        $this->load->view('index.php', $result);
    }

    public function about()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        $this->load->view('about', $result);
    }

    public function contact()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
      
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        $this->load->view('contact', $result);
    }

    public function quetion()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_info_app'] = $this->QuestionAnswerModel->selectInfo();

        $this->load->view('question', $result);
    }

    public function our_experts()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_clint_info'] = $this->ClientModel->selectInfoFront();

        $this->load->view('our_experts', $result);
    }

    public function online_directory()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        $result['all_info_cat'] = $this->CategoryModel->selectActiveInfo();

        $this->load->view('online_directory', $result);
    }

    public function gallery()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        $result['all_gallery_info'] = $this->GalleryModel->selectActiveInfo();

        $this->load->view('gallery', $result);
    }
    
    public function event()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_event_info'] = $this->EventModel->selectEventInfoActive();
        
        $this->load->view('event', $result);
    }
    

    public function soft_service()
    {
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        $this->load->view('software_services', $result);
    }

    public function web_service()
    {
        $this->load->view('website_services');
    }

    public function app_service()
    {
        $this->load->view('app_services');
    }

    public function course_inquiry()
    {
        $this->load->view('Course_Inquiry_form');
    }

    public function service_Inquiry_form()
    {
        $this->load->view('service_Inquiry_form');
    }

    public function registration()
    {
        $result['all_info'] = $this->CategoryModel->selectActiveInfo();
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();        
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);

        $this->load->view('registration', $result);
    }
    
    public function privacy_policy()
    {
               
        $this->load->view('privacy_policy');
    }
    

    public function thanks()
    {
        $result['all_info_add_top'] = $this->AdvertisementModel->manageFrontInfo(2);

        $this->load->view('frontheader', $result);
        $this->load->view('thanks');
        $this->load->view('front_footer');
    }

    public function clint_web()
    {
        $this->load->view('clint_web');
    }
    
    public function training_center()
    {
        $result['all_course_info'] = $this->CourseModel->selectInfoFront();
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        $this->load->view('training_center', $result);
        
    }
    
    
    public function print_media()
    {
        $result['all_info'] = $this->PaperCuttingModel->manageInfo();
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
        
        $this->load->view('print_media',$result);
        
    }
}