<?php
defined('BASEPATH') or exit('No direct script access allowed');

class EventControllers extends CI_Controller
{


	//...............State construct............

	public function __construct()
	{
		parent::__construct();
		$this->load->library("form_validation");
		$this->load->model("EventModel");
		$this->load->model("AdvertisementModel");
		$this->load->model("NewsModel");
		

		$this->load->library('upload');


	}

	//...............End construct............

	//...............State index function............



	public function index()
	{

		$this->load->view('admin/add_event');

	}


	//...............End index function............


	//...............State insert insertGalleryInfo............



	public function insertEventInfo()
	{
		$data = array(

			'name' => $this->input->post('Name'),
			'description' => $this->input->post('Description'),
			'event_date' => $this->input->post('Event_date')
		);

		$event_id = $this->EventModel->insertEventInfo('event_tb', $data);

		$this->uploadFiles($event_id);

	}






	//...............End insert insertGalleryInfo............

	//...............State insert uploadFiles............




	public function uploadFiles($event_id)
	{
		$config = array(
			'upload_path' => FCPATH . "./EventImages/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['uploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['uploads[]']['name'] = $files['name'][$key];
			$_FILES['uploads[]']['type'] = $files['type'][$key];
			$_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['uploads[]']['error'] = $files['error'][$key];
			$_FILES['uploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $event_id;



			$this->upload->initialize($config);

			if (isset($_FILES['uploads[]']['name']) && !empty($_FILES['uploads[]']['name'])) {
				if (!$this->upload->do_upload('uploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['uploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'image_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->EventModel->updateEventImageInfo($event_id, $array);
				}

			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($event_id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("EventControllers");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("EventControllers");
		}
	}


	public function uploadFilesUpdate($event_id)
	{
		$config = array(
			'upload_path' => FCPATH . "./EventImages/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['uploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['uploads[]']['name'] = $files['name'][$key];
			$_FILES['uploads[]']['type'] = $files['type'][$key];
			$_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['uploads[]']['error'] = $files['error'][$key];
			$_FILES['uploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $event_id;



			$this->upload->initialize($config);

			if (isset($_FILES['uploads[]']['name']) && !empty($_FILES['uploads[]']['name'])) {
				if (!$this->upload->do_upload('uploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['uploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'image_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->EventModel->updateEventImageInfo($event_id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($event_id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("EventControllers/manageInfo");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("EventControllers/manageInfo");
		}
	}


	//...............End insert uploadFiles............

	//...............State Manage Subgallerty............





	public function manageInfo()
	{


		$result['all_info'] = $this->EventModel->manageInfo();

		$this->load->view('admin/event_report', $result);

	}


	public function manageInfoFront()
	{

		$result['add_top'] = $this->AdvertisementModel->manageFrontInfo(1);
		$result['all_info'] = $this->EventModel->manageInfo();

		$this->load->view('news_info_all', $result);

	}



	public function manageFrontEvent()
	{


		$result['all_info_add_top'] = $this->AdvertisementModel->manageFrontInfo(2);
		$this->load->view('frontheader', $result);

		$result['event_info'] = $this->EventModel->selectEventInfoActive();
		$this->load->view('news', $result);

		$this->load->view('front_footer');





	}




	//...............End Manage Subgallerty............

	//...............State Get ID Wise Subgallery Info ............

	function getInfoById()
	{
		$id = $this->uri->segment(3);
		$data['single_event_data'] = $this->EventModel->getInfoById($id);


		$this->load->view('admin/edit_event', $data);
	}



	function getInfoFrontById()
	{
		$id = $this->uri->segment(3);	
		$result['all_news_info'] = $this->NewsModel->manageActiveInfo();
		$result['single_info'] = $this->EventModel->getInfoById($id);

		$this->load->view('event_full', $result);
	}

	function getFrontEventById()
	{
		$id = $this->uri->segment(3);
		
		$data['single_event_data'] = $this->EventModel->getEventById($id);

		
		$this->load->view('frontheader', $result);
		$this->load->view('newsinfo', $data);

		$this->load->view('front_footer');


		//	$this->load->view('front_footer');
	}
	//...............End Get ID Wise Subgallery Info ............

	//...............State Update Subgallery By ID ............


	function updateInfoById()
	{

		$id = $this->input->post('id');

		$data = array(
			'name' => $this->input->post('Name'),
			'description' => $this->input->post('Description'),
			'event_date' => $this->input->post('Event_date'),
			'status' => $this->input->post('Status')

		);
		$this->EventModel->updateInfoById($id, $data);

		$this->uploadFilesUpdate($id);
	}


	//...............End Update Subgallery By ID ............



	public function deleteInfo()
	{
		$id = $this->uri->segment(3);
		$image = $this->uri->segment(4);


		//	print_r($id); die;

		$this->EventModel->deleteInfo($id, $image);

		redirect("EventControllers/manageInfo");
	}





}