<?php
defined('BASEPATH') or exit('No direct script access allowed');

class DistrictControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("DistrictModel");
        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('admin/add_district');
    }

    // ...............End index function............

    // ...............State insert insertGalleryInfo............
    public function insertInfo()
    {
        $data = array(

            'NAME' => $this->input->post('Name')
        );

        $id = $this->DistrictModel->insertInfo('district_tb', $data);

        if ($id) {
            $this->session->set_flashdata('msg', 'Post Your Inquiry.');
            redirect("DistrictControllers/index");
        } else {
            $this->session->set_flashdata('msg', 'some error...');
            redirect("DistrictControllers/index");
        }
    }
    
    
    // ...............All Info ............

    public function manageInfo()
    {
        $result['all_info'] = $this->DistrictModel->selectInfo();
       
        $this->load->view('admin/district_report', $result);
    }
    
    
    // ...............Info By id ............
    function getInfoById()
    {
        $id = $this->uri->segment(3);
        $data['single_data'] = $this->DistrictModel->getInfoById($id);
        
        $this->load->view('admin/edit_district', $data);
    }
    
    
    
    
    // ............... Update Info By ID ............
    function updateInfoById()
    {
        $id = $this->input->post('id');
        
        $data = array(
            'NAME' => $this->input->post('Name'),
            'STATUS' => $this->input->post('Status')
        );
        $this->DistrictModel->updateInfoById($id, $data);
        
        redirect("DistrictControllers/manageInfo");
    }
    
    
    
    
    
    public function manageActiveInfo()
    {
        $result['all_info'] = $this->DistrictModel->selectActiveInfo();
        
        //$this->load->view('admin/district_report', $result);
    }
    


  

    // ...............End Update Subgallery By ID ............
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);

        // print_r($id); die;

        $this->DistrictModel->deleteInfo($id);

        redirect("DistrictControllers/manageInfo");
    }
}
