<?php
defined('BASEPATH') or exit('No direct script access allowed');

class CourseControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("CourseModel");
        $this->load->model("AdvertisementModel");

        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $this->load->view('admin/add_course');
    }

    // ...............End index function............

    // ...............State insert insertGalleryInfo............
    public function insertInfo()
    {
        $data = array(

            'name' => $this->input->post('Name'),
            'duration' => $this->input->post('Duration')
        );

        $id = $this->CourseModel->insertInfo('course_tb', $data);

        $this->uploadFiles($id);
    }

    // ...............End insert insertGalleryInfo............

    // ...............State insert uploadFiles............
    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./CourseImages/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $name = 'jpg';
                    } else {
                        $name = $array_a[1];
                    }
                    $array = array(

                        'image_formate' => $name
                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->CourseModel->updateImageInfo($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("CourseControllers");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("CourseControllers");
        }
    }

    public function uploadFilesUpdate($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./CourseImages/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $name = 'jpg';
                    } else {
                        $name = $array_a[1];
                    }
                    $array = array(

                        'image_formate' => $name
                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->CourseModel->updateImageInfo($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($gallery_id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("CourseControllers/manageInfo");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("CourseControllers/manageInfo");
        }
    }

    // ...............End insert uploadFiles............

    // ...............State Manage Subgallerty............
    public function manageInfo()
    {
        $result['all_info'] = $this->CourseModel->selectInfo();

        $this->load->view('admin/course_report', $result);
    }

    public function manageInfoFront()
    {
        $result['all_course_info'] = $this->CourseModel->selectInfoFront();

        $this->load->view('admin/course_report', $result);
    }

    // ...............End Manage Subgallerty............

    // ...............State Get ID Wise Subgallery Info ............
    function getInfoById()
    {
        $id = $this->uri->segment(3);

        $data['single_data'] = $this->CourseModel->getInfoById($id);

        $this->load->view('admin/edit_course', $data);
    }

    // ...............End Get ID Wise Subgallery Info ............

    // ...............State Update Subgallery By ID ............
    function updateInfoById()
    {
        $id = $this->input->post('id');

        $data = array(
            'name' => $this->input->post('Name'),
            'duration' => $this->input->post('Duration'),
            'status' => $this->input->post('Status')
        );
        $this->CourseModel->updateInfoById($id, $data);

        $this->uploadFilesUpdate($id);
    }

    // ...............End Update Subgallery By ID ............
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);

        $image = $this->uri->segment(4);

        // print_r($id); die;

        $this->CourseModel->deleteInfo($id, $image);

        redirect("CourseControllers/manageInfo");
    }
}