<?php
defined('BASEPATH') or exit('No direct script access allowed');

class RegistrationControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();

        $this->load->library("form_validation");
        $this->load->model("NewsModel");
        $this->load->model("AdvertisementModel");
        $this->load->model("RegistrationModel");
        $this->load->model("CategoryModel");
        $this->load->library('upload');
        $this->load->helper('url', 'form');
        $this->load->library("pagination");
    }

    // ...............End construct............
    public function checkMobileNo()

    {
        // print_r( $this->input->post('mobile_no')).die();
        $result = $this->RegistrationModel->usermobile_exists($this->input->post('mobile_no'));

        print_r($result);
    }

    // ..............add_registration............
    public function index()
    {
        $result['all_info'] = $this->CategoryModel->selectActiveInfo();

        $this->load->view('admin/add_registration', $result);
    }

    // ..............add Front registration............
    public function registration()
    {
        $result['all_info'] = $this->CategoryModel->selectActiveInfo();
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);

        $this->load->view('registration', $result);
    }

    // ..............thanks............
    public function requset_thanks()
    {
        $this->load->view('requset_thanks');
    }

    // ..............Insert And Update Registration............
    public function insertInfo()
    {
        $id = $this->input->post('id');
        $type = $this->input->post('Type');
        $data = array(
            'category_id_fk' => $this->input->post('Category_id_fk'),
            'owner_name' => $this->input->post('Owner_name'),
            'company_name' => $this->input->post('Company_name'),
            'address' => $this->input->post('Address'),
            'whatsapp_no' => $this->input->post('Whatsapp_no'),
            'mobile' => $this->input->post('Mobile'),
            'website_link' => $this->input->post('Website_link'),
            'product' => $this->input->post('Product'),
            'email' => $this->input->post('Email'),
            'facebook_link' => $this->input->post('Facebook_link'),
            'instagram_link' => $this->input->post('Instagram_link'),
            'youtube_link' => $this->input->post('Youtube_link'),
            'about' => $this->input->post('About'),
            'password' => $this->input->post('Password'),
            'live_location' => $this->input->post('Live_location'),
            'STATUS' => $this->input->post('Status')
        );

        if ($id == 0) {

            $id = $this->RegistrationModel->insertInfo('tbl_registration', $data);
        } else {

            $this->RegistrationModel->updateInfoById($id, $data);
        }

        $this->uploadFiles($id, $type);
    }

    // ..............One Image Upload Registration............
    public function uploadFiles($id, $type)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/RegistretionImage_One",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['image_one'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['image_one[]']['name'] = $files['name'][$key];
            $_FILES['image_one[]']['type'] = $files['type'][$key];
            $_FILES['image_one[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['image_one[]']['error'] = $files['error'][$key];
            $_FILES['image_one[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['image_one[]']['name']) && ! empty($_FILES['image_one[]']['name'])) {
                if (! $this->upload->do_upload('image_one[]')) {
                    $image_error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $this->upload->data();
                }
            }
        }

        $this->uploadFiles2($id, $type);
    }

    // ..............Second Image Upload Registration............
    public function uploadFiles2($id, $type)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/RegistretionImage_Two/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['image_two'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['image_two[]']['name'] = $files['name'][$key];
            $_FILES['image_two[]']['type'] = $files['type'][$key];
            $_FILES['image_two[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['image_two[]']['error'] = $files['error'][$key];
            $_FILES['image_two[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['image_two[]']['name']) && ! empty($_FILES['image_two[]']['name'])) {
                if (! $this->upload->do_upload('image_two[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $this->upload->data();
                }
            }
        }

        if ($type == "BackHend") {

            if ($id) {

                $this->session->set_flashdata('msg', 'data inserted.');
                redirect("RegistrationControllers/index");
            } else {
                $this->session->set_flashdata('msg', 'error...');
                redirect("RegistrationControllers/index");
            }
        } elseif ($type == "UpdateBackHend") {

            if ($id) {
                $this->session->set_flashdata('msg', 'data inserted.');

                redirect("RegistrationControllers/manageInfoBlock");
            } else {
                $this->session->set_flashdata('msg', 'error...');
                redirect("RegistrationControllers/manageInfoBlock");
            }
        }
    }

    // ..............Insert And Update Registration............
    public function insertFrontInfo()
    {
        $this->form_validation->set_rules('Mobile', 'Mobile', 'exact_length[10]|is_unique[tbl_registration.mobile]');
        $this->form_validation->set_rules('Password', 'Password', 'min_length[5]');
        $this->form_validation->set_message('is_unique', 'This Mobile is already exists.');

        if ($this->form_validation->run()) {

            $id = $this->input->post('id');
            $type = $this->input->post('Type');
            $data = array(
                'category_id_fk' => $this->input->post('Category_id_fk'),
                'owner_name' => $this->input->post('Owner_name'),
                'company_name' => $this->input->post('Company_name'),
                'address' => $this->input->post('Address'),
                'whatsapp_no' => $this->input->post('Whatsapp_no'),
                'mobile' => $this->input->post('Mobile'),
                'website_link' => $this->input->post('Website_link'),
                'product' => $this->input->post('Product'),
                'email' => $this->input->post('Email'),
                'facebook_link' => $this->input->post('Facebook_link'),
                'instagram_link' => $this->input->post('Instagram_link'),
                'youtube_link' => $this->input->post('Youtube_link'),
                'about' => $this->input->post('About'),
                'password' => $this->input->post('Password'),
                'live_location' => $this->input->post('Live_location'),
                'STATUS' => $this->input->post('Status'),
                
            );

            if ($id == 0) {

                $id = $this->RegistrationModel->insertInfo('tbl_registration', $data);
            } else {

                $this->RegistrationModel->updateInfoById($id, $data);
            }

            $this->uploadFiles($id, $type);
        } else {

            $result['all_info'] = $this->CategoryModel->selectActiveInfo();
            $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
            $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);

            $this->load->view('registration', $result);
        }
    }

    // ..............One Image Upload Registration............
    public function uploadFrontFiles($id, $type)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/RegistretionImage_One",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['image_one'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['image_one[]']['name'] = $files['name'][$key];
            $_FILES['image_one[]']['type'] = $files['type'][$key];
            $_FILES['image_one[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['image_one[]']['error'] = $files['error'][$key];
            $_FILES['image_one[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['image_one[]']['name']) && ! empty($_FILES['image_one[]']['name'])) {
                if (! $this->upload->do_upload('image_one[]')) {
                    $image_error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $this->upload->data();
                }
            }
        }

        $this->uploadFrontFiles2($id, $type);
    }

    // ..............Second Image Upload Registration............
    public function uploadFrontFiles2($id, $type)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/RegistretionImage_Two/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['image_two'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['image_two[]']['name'] = $files['name'][$key];
            $_FILES['image_two[]']['type'] = $files['type'][$key];
            $_FILES['image_two[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['image_two[]']['error'] = $files['error'][$key];
            $_FILES['image_two[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['image_two[]']['name']) && ! empty($_FILES['image_two[]']['name'])) {
                if (! $this->upload->do_upload('image_two[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $this->upload->data();
                }
            }
        }

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            redirect("IndexControllers/registration");
        } else {

            $this->session->set_flashdata('msg', 'error...');
            redirect("IndexControllers/registration");
        }
    }

    // ..............Block Registration............
    public function manageInfoBlock()
    {
        $result['all_info'] = $this->RegistrationModel->selectInfo('block');

        $this->load->view('admin/registration_report', $result);
    }

    // ..............Active Registration............
    public function manageInfoActive()
    {
        $result['all_info'] = $this->RegistrationModel->selectActiveInfo();

        $this->load->view('admin/registration_active_report', $result);
    }

    // ..............Cat Wise Active Registration............
    function getInfoByCatId()
    {
        $search = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        // $search = ($this->uri->segment(3)) ? $this->uri->segment(3) : $search;
        
       
        // pagination settings
        $config = array();
        $config['base_url'] = base_url() . "RegistrationControllers/getInfoByCatId/$search";
        $config['total_rows'] = $this->RegistrationModel->get_count($search);
        $config['per_page'] = "20";
        $config["uri_segment"] = 4;
        // $choice = $config["total_rows"] / $config["per_page"];
        $config["num_links"] = 20;

        // integrate bootstrap pagination
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = false;
        $config['last_link'] = false;
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['prev_link'] = 'Prev';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['next_link'] = 'Next';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);

        $data['page'] = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        // get books list
        $data['all_info_user'] = $this->RegistrationModel->selectInfoCatWiseFront($config['per_page'], $data['page'], $search);

        $data['pagination'] = $this->pagination->create_links();

        // load view
        $data['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $data['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);

        $this->load->view('all_clint', $data);
    }
    
    
    
    function getAllRegistrationBySearch()
    {
        $search = ($this->input->post('Name')) ? $this->input->post('Name') : "";
        
       // print_r($search).die;
        
    
        // $search = ($this->uri->segment(3)) ? $this->uri->segment(3) : $search;
        
        // pagination settings
        $config = array();
        $config['base_url'] = base_url() . "RegistrationControllers/getAllRegistrationBySearch/$search";
        $config['total_rows'] =  $config['total_rows'] = $this->RegistrationModel->getInfoSearchCount($search);;
        $config['per_page'] = "20";
        $config["uri_segment"] = 4;
        // $choice = $config["total_rows"] / $config["per_page"];
        $config["num_links"] = 20;
        
        // integrate bootstrap pagination
        $config['full_tag_open'] = '<ul class="pagination">';
        $config['full_tag_close'] = '</ul>';
        $config['first_link'] = false;
        $config['last_link'] = false;
        $config['first_tag_open'] = '<li>';
        $config['first_tag_close'] = '</li>';
        $config['prev_link'] = 'Prev';
        $config['prev_tag_open'] = '<li class="prev">';
        $config['prev_tag_close'] = '</li>';
        $config['next_link'] = 'Next';
        $config['next_tag_open'] = '<li>';
        $config['next_tag_close'] = '</li>';
        $config['last_tag_open'] = '<li>';
        $config['last_tag_close'] = '</li>';
        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $this->pagination->initialize($config);
        
        $data['page'] = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        // get books list
        $data['all_info_user'] = $this->RegistrationModel->getInfoSearch($config['per_page'], $data['page'], $search);
        
        $data['pagination'] = $this->pagination->create_links();
        
        // load view
        $data['all_news_info'] = $this->NewsModel->manageActiveInfo();
        
        $data['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);       
   
        
        $this->load->view('all_clint_search', $data);
    }
    
    
  /*   
    public function getAllRegistrationBySearch()
    {
       // print_r($this->input->post('Name'));
        
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);
            
        
             $result['all_info_user'] = $this->RegistrationModel->getInfoSearch($this->input->post('Name'));
        
        $this->load->view('all_clint_search', $result);
        
        
        
        
    }
     */
    

    public function departmentdata()
    {
        $config = array();
        $config["base_url"] = base_url() . "welcome/departmentdata";
        $config["total_rows"] = $this->RegistrationModel->record_count();
        $config["per_page"] = 5;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;
        $data["results"] = $this->RegistrationModel->fetch_departments($config["per_page"], $page);

        $data["links"] = $this->pagination->create_links();
        $this->load->view("departmentdata", $data);
    }

    // ..............Edit Registration By Id............
    function getInfoById()
    {
        $id = $this->uri->segment(3);

        $result['all_info'] = $this->CategoryModel->selectActiveInfo();
        $result['single_data'] = $this->RegistrationModel->getInfoById($id);
        $this->load->view('admin/edit_registration', $result);
    }

    // ..............Full Info Registration By Id............
    function getFullInfoById()
    {
        $id = $this->uri->segment(3);

        $result['single_data'] = $this->RegistrationModel->getInfoById($id);
        $this->load->view('clint_web', $result);
    }

    // ..............Delete Info Registration By Id............
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);

        $this->RegistrationModel->deleteInfo($id);

        redirect("RegistrationControllers/manageInfoBlock");
    }

    // ..............Use Less Code...........
    public function insertInfoFront()
    {
        $data = array(

            'category_id_fk' => $this->input->post('Category_id_fk'),
            'owner_name' => $this->input->post('Owner_name'),
            'company_name' => $this->input->post('Company_name'),
            'address' => $this->input->post('Address'),
            'whatsapp_no' => $this->input->post('Whatsapp_no'),
            'mobile' => $this->input->post('Mobile'),
            'website_link' => $this->input->post('Website_link'),
            'product' => $this->input->post('Product'),
            'email' => $this->input->post('Email'),
            'facebook_link' => $this->input->post('Facebook_link'),
            'instagram_link' => $this->input->post('Instagram_link'),
            'youtube_link' => $this->input->post('Youtube_link'),
            'about' => $this->input->post('About'),
            'password' => $this->input->post('Password')
        );

        $id = $this->RegistrationModel->insertInfo('tbl_registration', $data);

        $this->uploadFilesFront($id);
    }

    function updateInfoById()
    {
        $id = $this->input->post('id');
        $type = $this->input->post('Type');

        $data = array(
            'category_id_fk' => $this->input->post('Category_id_fk'),
            'owner_name' => $this->input->post('Owner_name'),
            'company_name' => $this->input->post('Company_name'),
            'address' => $this->input->post('Address'),
            'whatsapp_no' => $this->input->post('Whatsapp_no'),
            'mobile' => $this->input->post('Mobile'),
            'website_link' => $this->input->post('Website_link'),
            'product' => $this->input->post('Product'),
            'email' => $this->input->post('Email'),
            'facebook_link' => $this->input->post('Facebook_link'),
            'instagram_link' => $this->input->post('Instagram_link'),
            'youtube_link' => $this->input->post('Youtube_link'),
            'about' => $this->input->post('About'),
            'STATUS' => $this->input->post('Status')
        );
        $this->RegistrationModel->updateInfoById($id, $data);

        $this->uploadFiles($id, $type);
    }

    public function uploadFilesFront($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            // $config['file_name'] = $id;

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {

                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    $image_formate = $array_a[1];

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->RegistrationModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            $data['all_info'] = $this->CategoryModel->selectActiveInfo();

            $this->load->view('registration', $data);
        } else {

            $this->session->set_flashdata('msg', 'error...');

            $data['all_info'] = $this->CategoryModel->selectActiveInfo();

            $this->load->view('registration', $data);
        }
    }

    public function uploadUpdateFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./RegistretionImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            // $config['file_name'] = $filename;
            // $config['file_name'] = $record_id." ".$filename;
            $config['file_name'] = $id;

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    $uploads[] = $this->upload->data();

                    $array_a = explode('/', $_FILES['uploads[]']['type']);

                    if ($array_a[1] == 'jpeg') {
                        $image_formate = 'jpg';
                    } else {
                        $image_formate = $array_a[1];
                    }

                    $array = array(

                        'image_formate' => $image_formate

                        // 'size' => $_FILES['image']['size']
                    );

                    // $this->UploadImageModel->addData('image_upload', $array);

                    $this->RegistrationModel->updateImage($id, $array);
                }
            }
        }
        // redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("RegistrationControllers/manageInfoBlock");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            redirect("RegistrationControllers/manageInfoBlock");
        }
    }

    function getInfoByCatId1()
    {
        $id = $this->uri->segment(3);

        $config = array();
        $config["base_url"] = base_url() . "/RegistrationControllers/getInfoByCatId";
        $config["total_rows"] = $this->RegistrationModel->get_count($id);
        ;
        $config["per_page"] = 10;
        $config["uri_segment"] = 3;
        $this->pagination->initialize($config);

        $page = ($this->uri->segment(3)) ? $this->uri->segment(3) : 0;

        $result["links"] = $this->pagination->create_links();

        // $result['all_info_user'] = $this->RegistrationModel->get_students($config["per_page"], $page);
        $result['all_news_info'] = $this->NewsModel->manageActiveInfo();
        $result['all_add_info_top'] = $this->AdvertisementModel->manageFrontInfo(1);

        $result['all_info_user'] = $this->RegistrationModel->selectInfoCatWiseFrontS($config["per_page"], $page, $id);

        $this->load->view('all_user', $result);
    }

    // ..............App Old Method
    public function manageInfoCatWise()
    {
        $id = $this->input->get('id');

        $result['all_info_user'] = $this->RegistrationModel->selectInfoCatWiseFront($id);

        print_r(json_encode($result));
    }

    function getFullById()
    {
        $id = $this->input->get('id');

        $result['single_data'] = $this->RegistrationModel->getInfoById($this->input->get('id'));

        print_r(json_encode($result));
    }

    public function upload_img()
    {
        $image = base64_decode($this->input->post("image"));
        $image_name = md5(uniqid(rand(), true));

        $data_insert1 = array(

            'category_id_fk' => $this->input->post('category_id_fk'),
            'owner_name' => $this->input->post('owner_name'),
            'company_name' => $this->input->post('company_name'),
            'address' => $this->input->post('address'),
            'Phon_no' => $this->input->post('Phon_no'),
            'mobile' => $this->input->post('mobile'),
            'web_link' => $this->input->post('web_link'),
            'product' => $this->input->post('product')
        );

        $id = $this->RegistrationModel->insertInfo('tbl_registration', $data_insert1);

        // $data_insert = array('image_formate'=>$filename1);

        if ($id > 0) {

            $path = "RegistretionImage/";

            $filename = $id . '.' . 'jpg';

            $formate = "jpg";

            file_put_contents($path . $filename, $image);

            $data_insert = array(
                'image_formate' => $formate
            );

            $success = $this->RegistrationModel->updateInfoById($id, $data_insert);
            if ($success) {
                $b = "User Registered Successfully..";
            } else {
                $b = "Some Error Occured. Please Try Again..";
            }

            echo json_encode($b);
        }
    }

    public function upload_img_update()
    {
        $image = base64_decode($this->input->post("image"));
        $image_name = md5(uniqid(rand(), true));

        // $data_insert = array('image_formate'=>$filename1);

        $id = $this->input->post('id');

        if ($id > 0) {
            $filename = $id . '.' . 'jpg';

            $path = "DistrictMemberImage/";

            $formate = "jpg";

            if (isset($image) && ! empty($image)) {
                file_put_contents($path . $filename, $image);
            }

            $data_insert = array(
                'district_id_fk' => $this->input->post('district_id_fk'),
                'city_id_fk' => $this->input->post('city_id_fk'),
                'NAME' => $this->input->post('NAME'),
                'mobile_no' => $this->input->post('mobile_no'),
                'shop' => $this->input->post('shop'),
                'image_formate' => $formate
            );

            $success = $this->DistrictMemberModel->updateInfoById($id, $data_insert);

            if ($success) {
                $b = "User Registered Successfully..";
            } else {
                $b = "Some Error Occured. Please Try Again..";
            }

            echo json_encode($b);
        }
    }
}