<?php
defined('BASEPATH') or exit('No direct script access allowed');

class PaperCuttingControllers extends CI_Controller
{


	//...............State construct............

	public function __construct()
	{
		parent::__construct();
		$this->load->library("form_validation");
		$this->load->model("PaperCuttingModel");
		$this->load->model("AdvertisementModel");
		
		$this->load->library('upload');



	}

	//...............End construct............

	//...............State index function............



	public function index()
	{
		
		$this->load->view('admin/add_paper_cutting');

	}


	//...............End index function............


	//...............State insert insertGalleryInfo............


	public function insertInfo()
	{
		$data = array(

			'name' => $this->input->post('Name'),
			'link' => $this->input->post('Link')

		);

		$id = $this->PaperCuttingModel->insertInfo('paper_cutting_tb', $data);

		$this->uploadFiles($id);

	}

	//...............End insert insertGalleryInfo............

	//...............State insert uploadFiles............


	public function uploadFiles($id)
	{
		$config = array(
			'upload_path' => FCPATH . "./PaperCuttingImage/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['uploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['uploads[]']['name'] = $files['name'][$key];
			$_FILES['uploads[]']['type'] = $files['type'][$key];
			$_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['uploads[]']['error'] = $files['error'][$key];
			$_FILES['uploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['uploads[]']['name']) && !empty($_FILES['uploads[]']['name'])) {
				if (!$this->upload->do_upload('uploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['uploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'image_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->PaperCuttingModel->updateImageInfo($id, $array);
				}

			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("PaperCuttingControllers");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("PaperCuttingControllers");
		}
	}


	public function uploadFilesUpdate($id)
	{
		$config = array(
			'upload_path' => FCPATH . "./PaperCuttingImage/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['uploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['uploads[]']['name'] = $files['name'][$key];
			$_FILES['uploads[]']['type'] = $files['type'][$key];
			$_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['uploads[]']['error'] = $files['error'][$key];
			$_FILES['uploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $id;



			$this->upload->initialize($config);

			if (isset($_FILES['uploads[]']['name']) && !empty($_FILES['uploads[]']['name'])) {
				if (!$this->upload->do_upload('uploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['uploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'image_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->PaperCuttingModel->updateImageInfo($id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("PaperCuttingControllers/manageInfo");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("PaperCuttingControllers/manageInfo");
		}
	}


	//...............End insert uploadFiles............

	//...............State Manage Subgallerty............





	public function manageInfo()
	{
		
		$result['all_info'] = $this->PaperCuttingModel->manageInfo();

		$this->load->view('admin/paper_cutting_report', $result);

	}


	public function getFrontInfoActive()
	{
	
		
		$result['all_info'] = $this->PaperCuttingModel->manageActiveInfo();

		$this->load->view('printing_press', $result);

	}


	public function manageInfoActive()
	{
		$this->load->view('admin/header');

		$result['all_info'] = $this->PaperCuttingModel->selectInfoActive('slider_tb', array());

		$this->load->view('admin/manage_slider', $result);

	}



	//...............End Manage Subgallerty............

	//...............State Get ID Wise Subgallery Info ............

	function getInfoById()
	{
		$id = $this->uri->segment(3);
		$data['single_data'] = $this->PaperCuttingModel->getInfoById($id);
	

		$this->load->view('admin/edit_paper_cutting', $data);
	}
	//...............End Get ID Wise Subgallery Info ............

	//...............State Update Subgallery By ID ............


	function updateInfoById()
	{

		$id = $this->input->post('id');

		$data = array(
			'name' => $this->input->post('Name'),
			'link' => $this->input->post('Link'),
			'status' => $this->input->post('status')

		);
		$this->PaperCuttingModel->updateInfoById($id, $data);

		$this->uploadFilesUpdate($id);
	}


	//...............End Update Subgallery By ID ............




	//...............delete data By Id And With Image...........

	public function deleteInfo()
	{
		$id = $this->uri->segment(3);
		$image = $this->uri->segment(4);


		//	print_r($id); die;

		$this->PaperCuttingModel->deleteInfo($id, $image);

		redirect("PaperCuttingControllers/manageInfo");
	}


}