<?php
defined('BASEPATH') or exit('No direct script access allowed');

class GalleryControllers extends CI_Controller
{


	//...............State construct............

	public function __construct()
	{
		parent::__construct();
		$this->load->library("form_validation");
		$this->load->model("GalleryModel");
		$this->load->library('upload');		
	}

	//...............End construct............

	//...............State index function............



	public function index()
	{

		$this->load->view('admin/add_gallery');

	}



	public function insertInfo()
	{
		$data = array(

			'name' => $this->input->post('Name')
		);

		$gallery_id = $this->GalleryModel->insertInfo('gallery_tb', $data);

		$this->uploadFiles($gallery_id);

	}



	public function uploadFiles($gallery_id)
	{
		$config = array(
			'upload_path' => FCPATH . "./GalleryImages/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['uploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['uploads[]']['name'] = $files['name'][$key];
			$_FILES['uploads[]']['type'] = $files['type'][$key];
			$_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['uploads[]']['error'] = $files['error'][$key];
			$_FILES['uploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $gallery_id;



			$this->upload->initialize($config);

			if (isset($_FILES['uploads[]']['name']) && !empty($_FILES['uploads[]']['name'])) {
				if (!$this->upload->do_upload('uploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['uploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'image_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->GalleryModel->updateImageInfo($gallery_id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($gallery_id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("GalleryControllers");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("GalleryControllers");
		}
	}


	public function uploadFilesUpdate($gallery_id)
	{
		$config = array(
			'upload_path' => FCPATH . "./GalleryImages/",
			'allowed_types' => 'jpg|png|jpeg',
			'overwrite' => TRUE,
		);

		$this->load->library('upload', $config);

		$files = $_FILES['uploads'];

		foreach ($files['name'] as $key => $filename) {
			$_FILES['uploads[]']['name'] = $files['name'][$key];
			$_FILES['uploads[]']['type'] = $files['type'][$key];
			$_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
			$_FILES['uploads[]']['error'] = $files['error'][$key];
			$_FILES['uploads[]']['size'] = $files['size'][$key];

			// $config['file_name'] = $filename;
			// $config['file_name'] = $record_id." ".$filename;
			$config['file_name'] = $gallery_id;



			$this->upload->initialize($config);

			if (isset($_FILES['uploads[]']['name']) && !empty($_FILES['uploads[]']['name'])) {
				if (!$this->upload->do_upload('uploads[]')) {
					$error = array('error' => $this->upload->display_errors());

				} else {
					$uploads[] = $this->upload->data();


					$array_a = explode('/', $_FILES['uploads[]']['type']);

					if ($array_a[1] == 'jpeg') {
						$name = 'jpg';
					} else {
						$name = $array_a[1];
					}
					$array = array(

						'image_formate' => $name
						//'size'      => $_FILES['image']['size']
					);


					// $this->UploadImageModel->addData('image_upload', $array);

					$this->GalleryModel->updateImageInfo($gallery_id, $array);
				}
			}
		}
		//redirect(site_url() . '/SubGalaryControllers/index/' . $record_id);

		if ($gallery_id) {
			$this->session->set_flashdata('msg', 'data inserted.');
			redirect("GalleryControllers/manageInfo");
		} else {
			$this->session->set_flashdata('msg', 'error...');
			redirect("GalleryControllers/manageInfo");
		}
	}


	public function manageInfo()
	{

		$result['all_info'] = $this->GalleryModel->selectInfo('gallery_tb', array());

		$this->load->view('admin/gallery_report', $result);

	}

	public function getAllActiveInfo()
	{
		$result['all_info_front'] = $this->GalleryModel->selectActiveInfo();	
		$this->load->view('sub_gallery', $result);
	
	}


	function getInfoById()
	{
		$id = $this->uri->segment(3);

		$data['single_data'] = $this->GalleryModel->getInfoById($id);

		$this->load->view('admin/edit_gallery', $data);
		
	}

	function updateInfoById()
	{

		$id = $this->input->post('id');

		$data = array(
			'name' => $this->input->post('Name'),
			'status' => $this->input->post('Status'),

		);
		$this->GalleryModel->updateInfoById($id, $data);

		$this->uploadFilesUpdate($id);
	}
	//...............End Update Subgallery By ID ............


	
	public function deleteInfo()
	{
	    $id = $this->uri->segment(3);
	    $image = $this->uri->segment(4);
	    //	print_r($id); die;
	    
	    $this->GalleryModel->deleteInfo($id, $image);
	    
	    redirect("GalleryControllers/manageInfo");
	}


}