<?php
defined('BASEPATH') or exit('No direct script access allowed');

class AdvertisementControllers extends CI_Controller
{

    // ...............State construct............
    public function __construct()
    {
        parent::__construct();
        $this->load->library("form_validation");
        $this->load->model("AdvertisementModel");
        $this->load->library('upload');
    }

    // ...............End construct............

    // ...............State index function............
    public function index()
    {
        $result['front_all_info'] = $this->AdvertisementModel->getLocationInfo();
        $this->load->view('admin/add_advertisement', $result);
    }

    // ...............End index function............

    // ...............State insert insertGalleryInfo............
    public function insertInfo()
    {
        $data = array(

            'name' => $this->input->post('Name'),
            'link' => $this->input->post('Link'),
            'location_id_fk' => $this->input->post('Location_id_fk')
        );

        $id = $this->AdvertisementModel->insertInfo('advertise_tb', $data);

        $this->uploadFiles($id);
    }

    // ...............End insert insertGalleryInfo............

    // ...............State insert uploadFiles............
    public function uploadFiles($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./AdvertiseImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );

        $this->load->library('upload', $config);

        $files = $_FILES['uploads'];

        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];

            $config['file_name'] = $id . '.' . 'jpg';

            $this->upload->initialize($config);

            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {

                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {

               
                    $uploads[] = $this->upload->data();

                    $image = base_url() . "./AdvertiseImage/" . $id . '.' . 'jpg';
                    
                   

                    $array = array(

                        'image_formate' => $image
                    );
                   
                    $this->AdvertisementModel->updateImageInfo($id, $array);
                }
            }
        }

        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');

            redirect("AdvertisementControllers");
        } else {
            $this->session->set_flashdata('msg', 'error...');

            redirect("AdvertisementControllers");
        }
    }

    public function uploadFilesUpdate($id)
    {
        $config = array(
            'upload_path' => FCPATH . "./AdvertiseImage/",
            'allowed_types' => 'jpg|png|jpeg',
            'overwrite' => TRUE
        );
        
        $this->load->library('upload', $config);
        
        $files = $_FILES['uploads'];
        
        foreach ($files['name'] as $key => $filename) {
            $_FILES['uploads[]']['name'] = $files['name'][$key];
            $_FILES['uploads[]']['type'] = $files['type'][$key];
            $_FILES['uploads[]']['tmp_name'] = $files['tmp_name'][$key];
            $_FILES['uploads[]']['error'] = $files['error'][$key];
            $_FILES['uploads[]']['size'] = $files['size'][$key];
            
            $config['file_name'] = $id . '.' . 'jpg';
            
            $this->upload->initialize($config);
            
            if (isset($_FILES['uploads[]']['name']) && ! empty($_FILES['uploads[]']['name'])) {
                
                if (! $this->upload->do_upload('uploads[]')) {
                    $error = array(
                        'error' => $this->upload->display_errors()
                    );
                } else {
                    
                    
                    $uploads[] = $this->upload->data();
                    
                    $image = base_url() . "./AdvertiseImage/" . $id . '.' . 'jpg';
                    
                    
                    
                    $array = array(
                        
                        'image_formate' => $image
                    );
                    
                    $this->AdvertisementModel->updateImageInfo($id, $array);
                }
            }
        }
        
        if ($id) {
            $this->session->set_flashdata('msg', 'data inserted.');
            
            redirect("AdvertisementControllers/getInfo");
        } else {
            $this->session->set_flashdata('msg', 'error...');
            
            redirect("AdvertisementControllers/getInfo");
        }
    }

    // ...............End insert uploadFiles............

    // ...............State Manage Subgallerty............
    public function getInfo()
    {
        $result['all_info'] = $this->AdvertisementModel->getInfo();

        $this->load->view('admin/advertisement_report', $result);
    }

    public function manageFrontInfoSlider()
    {
        $this->load->view('frontheader');

        $result['all_info'] = $this->AdvertisementModel->manageFrontInfo(1);

        $this->load->view('admin/manage_advertisement', $result);
        $this->load->view('front_footer');
    }

    // ...............End Manage Subgallerty............

    // ...............State Get ID Wise Subgallery Info ............
    function getInfoById()
    {
        $id = $this->uri->segment(3);
        $data['front_all_info'] = $this->AdvertisementModel->getLocationInfo();
        $data['single_data'] = $this->AdvertisementModel->getInfoById($id);

        $this->load->view('admin/edit_advertisement', $data);
    }

    // ...............End Get ID Wise Subgallery Info ............

    // ...............State Update Subgallery By ID ............
    function updateInfoById()
    {
        $id = $this->input->post('id');

        $data = array(
            'name' => $this->input->post('Name'),
            'link' => $this->input->post('Link'),
            'location_id_fk' => $this->input->post('Location_id_fk'),
            'STATUS' => $this->input->post('Status')
        );
        $this->AdvertisementModel->updateInfoById($id, $data);

        $this->uploadFilesUpdate($id);
    }

    // ...............End Update Subgallery By ID ............
    public function deleteInfo()
    {
        $id = $this->uri->segment(3);
        $image = $this->uri->segment(4);

        // print_r($id); die;

        $this->AdvertisementModel->deleteInfo($id, $image);

        redirect("AdvertisementControllers/getInfo");
    }
}